# Plot a function y = f(x)
# Load necessary libraries
library(ggplot2)

# Minimum and maximum values of x
xmin <- -5
# Use for ln function, must have x > 0
# xmin <- 0.001
xmax <- 5
# Divisions between xmin and xmax (more = smoother graph)
xdiv <- 100
xlength <- (xmax-xmin)/xdiv

# Find x values for the plot
x <- seq(xmin,xmax,xlength)

# Insert y = f(x) formula here
# line function
y <- 2*x + 1 
# quadratic function
#y <- -x**2 + 2*x + 5 
# exponential function
#y <- exp(x)
# ln function
#y <- log(x)
# absolute value function
#y <- abs(x)
# normal distribution
#mu <- 1 
#sig2 <- 1 
#y <- (1/sqrt(2*3.14159*sig2))*exp(-((x-mu)**2)/(2*sig2))

# Make data frame for ggplot2
plotdata <- as.data.frame(cbind(x,y))

# Print data
plotdata

# Plot the values
ggplot(plotdata,aes(x,y))+
geom_line(color="red",size=1)+
ggtitle("Plot a function y = f(x)")

